/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.elevator;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactBlockEntity;
import com.simibubi.create.content.contraptions.elevator.ElevatorFloorListPacket;
import com.simibubi.create.content.contraptions.pulley.PulleyContraption;
import com.simibubi.create.content.redstone.contact.RedstoneContactBlock;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ElevatorContraption
extends PulleyContraption {
    protected ElevatorColumn.ColumnCoords column;
    protected int contactYOffset;
    public boolean arrived;
    private int namesListVersion = -1;
    public List<IntAttached<Couple<String>>> namesList = ImmutableList.of();
    public int clientYTarget;
    public int maxContactY;
    public int minContactY;
    private int contacts;

    public ElevatorContraption() {
    }

    public ElevatorContraption(int initialOffset) {
        super(initialOffset);
    }

    @Override
    public void tickStorage(AbstractContraptionEntity entity) {
        super.tickStorage(entity);
        if (entity.field_6012 % 10 != 0) {
            return;
        }
        ElevatorColumn.ColumnCoords coords = this.getGlobalColumn();
        ElevatorColumn column = ElevatorColumn.get((class_1936)entity.method_37908(), coords);
        if (column == null) {
            return;
        }
        if (column.namesListVersion == this.namesListVersion) {
            return;
        }
        this.namesList = column.compileNamesList();
        this.namesListVersion = column.namesListVersion;
        AllPackets.getChannel().sendToClientsTracking((S2CPacket)new ElevatorFloorListPacket(entity, this.namesList), (class_1297)entity);
    }

    @Override
    protected void disableActorOnStart(MovementContext context) {
    }

    public ElevatorColumn.ColumnCoords getGlobalColumn() {
        return this.column.relative(this.anchor);
    }

    public Integer getCurrentTargetY(class_1937 level) {
        ElevatorColumn.ColumnCoords coords = this.getGlobalColumn();
        ElevatorColumn column = ElevatorColumn.get((class_1936)level, coords);
        if (column == null) {
            return null;
        }
        if (!column.isTargetAvailable()) {
            return null;
        }
        int targetedYLevel = column.getTargetedYLevel();
        if (this.isTargetUnreachable(targetedYLevel)) {
            return null;
        }
        return targetedYLevel;
    }

    public boolean isTargetUnreachable(int contactY) {
        return contactY < this.minContactY || contactY > this.maxContactY;
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        if (this.blocks.size() <= 0) {
            return false;
        }
        if (this.contacts == 0) {
            throw new AssemblyException((class_2561)Lang.translateDirect("gui.assembly.exception.no_contacts", new Object[0]));
        }
        if (this.contacts > 1) {
            throw new AssemblyException((class_2561)Lang.translateDirect("gui.assembly.exception.too_many_contacts", new Object[0]));
        }
        ElevatorColumn column = ElevatorColumn.get((class_1936)world, this.getGlobalColumn());
        if (column != null && column.isActive()) {
            throw new AssemblyException((class_2561)Lang.translateDirect("gui.assembly.exception.column_conflict", new Object[0]));
        }
        this.startMoving(world);
        return true;
    }

    @Override
    protected Pair<class_3499.class_3501, class_2586> capture(class_1937 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        if (!AllBlocks.REDSTONE_CONTACT.has(blockState)) {
            return super.capture(world, pos);
        }
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)RedstoneContactBlock.field_10927);
        if (facing.method_10166() == class_2350.class_2351.field_11052) {
            return super.capture(world, pos);
        }
        ++this.contacts;
        class_2338 local = this.toLocalPos(pos.method_10093(facing));
        this.column = new ElevatorColumn.ColumnCoords(local.method_10263(), local.method_10260(), facing.method_10153());
        this.contactYOffset = local.method_10264();
        return super.capture(world, pos);
    }

    public int getContactYOffset() {
        return this.contactYOffset;
    }

    public void broadcastFloorData(class_1937 level, class_2338 contactPos) {
        ElevatorColumn column = ElevatorColumn.get((class_1936)level, this.getGlobalColumn());
        class_2586 class_25862 = this.world.method_8321(contactPos);
        if (!(class_25862 instanceof ElevatorContactBlockEntity)) {
            return;
        }
        ElevatorContactBlockEntity ecbe = (ElevatorContactBlockEntity)class_25862;
        if (column != null) {
            column.floorReached((class_1936)level, ecbe.shortName);
        }
    }

    @Override
    public class_2487 writeNBT(boolean spawnPacket) {
        class_2487 tag = super.writeNBT(spawnPacket);
        tag.method_10556("Arrived", this.arrived);
        tag.method_10566("Column", (class_2520)this.column.write());
        tag.method_10569("ContactY", this.contactYOffset);
        tag.method_10569("MaxContactY", this.maxContactY);
        tag.method_10569("MinContactY", this.minContactY);
        return tag;
    }

    @Override
    public void readNBT(class_1937 world, class_2487 nbt, boolean spawnData) {
        this.arrived = nbt.method_10577("Arrived");
        this.column = ElevatorColumn.ColumnCoords.read(nbt.method_10562("Column"));
        this.contactYOffset = nbt.method_10550("ContactY");
        this.maxContactY = nbt.method_10550("MaxContactY");
        this.minContactY = nbt.method_10550("MinContactY");
        super.readNBT(world, nbt, spawnData);
    }

    @Override
    public ContraptionType getType() {
        return ContraptionType.ELEVATOR;
    }

    public void setClientYTarget(int clientYTarget) {
        if (this.clientYTarget == clientYTarget) {
            return;
        }
        this.clientYTarget = clientYTarget;
        this.syncControlDisplays();
    }

    public void syncControlDisplays() {
        if (this.namesList.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.namesList.size(); ++i) {
            if ((Integer)this.namesList.get(i).getFirst() != this.clientYTarget) continue;
            this.setAllControlsToFloor(i);
        }
    }

    public void setAllControlsToFloor(int floorIndex) {
        for (MutablePair pair : this.actors) {
            Object object;
            if (pair.right == null || !((object = ((MovementContext)pair.right).temporaryData) instanceof ContraptionControlsMovement.ElevatorFloorSelection)) continue;
            ContraptionControlsMovement.ElevatorFloorSelection efs = (ContraptionControlsMovement.ElevatorFloorSelection)object;
            efs.currentIndex = floorIndex;
        }
    }
}

